<?php
require 'koneksi.php';
require_once("dompdf/autoload.inc.php");

use Dompdf\Dompdf;
use Dompdf\Options;

// **Dompdf Configuration**
$options = new Options();
$options->set('isRemoteEnabled', true);
$options->set('isHtml5ParserEnabled', true);
$options->set('defaultFont', 'Arial');
$options->set('isPhpEnabled', true);
$options->set('isFontSubsettingEnabled', true);

$dompdf = new Dompdf($options);

// **Fetch Data from Database**
$bobot = query("SELECT * FROM bobot1")[0];  // Fetch weights
$nilai_alternatif = query("SELECT * FROM mahasiswa ORDER BY id ASC");  // Sort by original ID
$hasil_vektor_s = query("SELECT * FROM vektors1 ORDER BY id ASC");  // Fetch by original ID
$hasil_vektor_v = query("SELECT * FROM hasil1 ORDER BY id_hasil ASC");  // Fetch by original ID

// **Check if all required data is available**
if (!$bobot || !$nilai_alternatif || !$hasil_vektor_s || !$hasil_vektor_v) {
    die("⚠️ Data is not available! Please make sure the tables `bobot1`, `input_nilai1`, `vektors1`, and `hasil1` are filled.");
}

// **Calculate total weight**
$jumlah_bobot = array_sum($bobot);
if ($jumlah_bobot == 0) {
    die("⚠️ Weight must not be zero! Please recheck the input weights.");
}

// **Normalize Weights**
$w = [];
foreach ($bobot as $key => $value) {
    if ($key != 'id_bobot1') {
        $w[$key] = $value / $jumlah_bobot;
    }
}

// **Total Vector S & V**
$total_s = array_sum(array_column($hasil_vektor_s, 'nilai'));
$total_v = array_sum(array_column($hasil_vektor_v, 'nilai'));

// **Auto Date**
$tanggal = date("d-m-Y");

// **HTML Structure for PDF**
$html = '<html>
<head>
    <style>
        body { font-family: Arial, sans-serif; font-size: 12px; }
        .table1 {
            width: 100%;
            border-collapse: collapse;
            text-align: center;
        }
        .table1, th, td {
            border: 1px solid #000;
            padding: 5px;
            font-size: 10px;
        }
        h2, p {
            text-align: center;
        }
        h3 {
            text-decoration: underline;
            text-align: center;
        }
        h1 {
            text-align: center;
            font-size: 22px;
        }
    </style>
</head>
<body>
    <br>
    <h1>Evaluation Report on the Effectiveness of Using YouTube as a Learning Media for Informatics Engineering Students Using the Weighted Product Method</h1>
    <h2>Nusa Putra University</h2>
    <p>Sukabumi - Bogor - West Java - Indonesia</p>
    <p>Date: ' . htmlspecialchars($tanggal) . '</p>
<hr style="border: 2px solid black;" />

    <br><br>';

// **Criteria Weight Table**
$html .= '<h3>Criteria Weight Data</h3>
<table class="table1">
<tr>
    <th>Criteria</th>
    <th>Weight</th>
    <th>Normalized Weight</th>
</tr>';

foreach ($w as $key => $value) {
    $html .= '<tr>
        <td>' . strtoupper($key) . '</td>
        <td>' . intval($bobot[$key]) . '</td>
        <td>' . number_format($value, 6) . '</td>
    </tr>';
}
$html .= '</table><br><br>';
$html .= '<hr style="border: 1px solid #ccc;">';

// **Alternative Value Table**
$html .= '<h3>Alternative Value Data</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Name</th>
    <th>C1</th>
    <th>C2</th>
    <th>C3</th>
    <th>C4</th>
    <th>C5</th>
    <th>C6</th>
    <th>C7</th>
    <th>Average Score</th>
</tr>';

$no = 1;
$total_rata_rata = 0;
foreach ($nilai_alternatif as $alt) {
    $nilai = [
        $alt["c1"], $alt["c2"], $alt["c3"], $alt["c4"], $alt["c5"], $alt["c6"], $alt["c7"]
    ];
    $rata_rata = array_sum($nilai) / count($nilai);
    $total_rata_rata += $rata_rata;

    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($alt["alternatif"]) . '</td>
        <td>' . intval($alt["c1"]) . '</td>
        <td>' . intval($alt["c2"]) . '</td>
        <td>' . intval($alt["c3"]) . '</td>
        <td>' . intval($alt["c4"]) . '</td>
        <td>' . intval($alt["c5"]) . '</td>
        <td>' . intval($alt["c6"]) . '</td>
        <td>' . intval($alt["c7"]) . '</td>
        <td>' . number_format($rata_rata, 6) . '</td>
    </tr>';
}
$html .= '</table><br><br>';
$total_average = $total_rata_rata / count($nilai_alternatif);
$html .= "<p style='text-align:center; font-weight:bold;'>Total Average of All Alternatives: " . number_format($total_average, 6) . "</p><br><br>";
$html .= '<hr style="border: 1px solid #ccc;">';

// **Vector S Result Table**
$html .= '<h3>Vector S Results</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Alternative</th>
    <th>Vector S Value</th>
</tr>';

$no = 1;
foreach ($hasil_vektor_s as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["alternatif"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>
    </tr>';
}
$html .= '</table><br><br>';
$html .= "<p style='text-align:center; font-weight:bold;'>Total Vector S Value: " . number_format($total_s, 6) . "</p><br><br>";
$html .= '<hr style="border: 1px solid #ccc;">';

// **Vector V Result Table**
$html .= '<h3>Vector V Results</h3>
<table class="table1">
<tr>
    <th>No.</th>
    <th>Alternative</th>
    <th>Vector V Value</th>
</tr>';

$no = 1;
foreach ($hasil_vektor_v as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["alternatif"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>
    </tr>';
}
$html .= '</table><br><br>';
$html .= "<p style='text-align:center; font-weight:bold;'>Total Vector V Value: " . number_format($total_v, 6) . "</p><br><br>";
$html .= '<hr style="border: 1px solid #ccc;">';

// **Ranking Result Table**
$html .= '<h3>Ranking Results</h3>
<table class="table1">
<tr>
    <th>Rank</th>
    <th>Name</th>
    <th>Value</th>
</tr>';

$no = 1;
$hasil_vektor_v_ranked = $hasil_vektor_v;
usort($hasil_vektor_v_ranked, fn($a, $b) => $b['nilai'] <=> $a['nilai']);

foreach ($hasil_vektor_v_ranked as $data) {
    $html .= '<tr>
        <td>' . $no++ . '</td>
        <td>' . htmlspecialchars($data["alternatif"]) . '</td>
        <td>' . number_format($data["nilai"], 6) . '</td>
    </tr>';
}
$html .= '</table><br><br>';

// **Close HTML**
$html .= "</body></html>";

// **Generate PDF with Dompdf**
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'landscape');
$dompdf->render();
$dompdf->stream('Evaluation_Report_YouTube.pdf', array("Attachment" => 0));
?>
